<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

abstract class XenCentral_AdServer_Locations_Abstract implements ArrayAccess // allows to have location data in templates
{
    protected $wrapper='xcas_zone_wrapper_default';
    /**
     * @var
     * Stores prepared template for admin manager
     */
    protected $prepared_template;

    /**
     * @return String
     * Returns unique string identified for the location
     */
    public abstract function getLocationId();

    /**
     * @return String|XenForo_Phrase
     * Title for the location to be used in Admin Panel
     */
    public abstract function getTitle();

    /**
     * @return String|XenForo_Phrase
     * Name of group for locations. Will be used to create tabs in Zone Manager
     */
    public abstract function getGroup();

    /**
     * @return String|XenForo_Phrase
     * Name of sub-group for locations. Will be used to fieldsets in tabs
     */
    public abstract function getSubGroup();

    /**
     * @return String
     * Each location type should set its template name to be used to render location in Admin Panel
     */
    public abstract function getOptionTemplate();

    /**
     * @return string|XenForo_Phrase
     * Description for the location if needed
     */
    public function getDescription()
    {
        return '';
    }

    /**
     * @return string
     * Returns the URL of an image explainin the location
     */
    public function getExplainImage()
    {
        if(file_exists(XenForo_Application::getInstance()->getRootDir().'/banners/locations/'.$this->getLocationId().'.png')) {
            return XenForo_Application::getOptions()->get('boardUrl').'/banners/locations/'.$this->getLocationId().'.png';
        }
        return '';
    }

    /**
     * @return bool
     * Called just before the location is used, and can be used to prevent execution
     */
    public function preCheck()
    {
       return true;
    }

    /**
     * @return string
     * The default wrapper template for the location
     */
    public function getWrapper()
    {
        return $this->wrapper;
    }

    /**
     * @param mixed $prepared_template
     */
    public function setPreparedTemplate($prepared_template)
    {
        $this->prepared_template = $prepared_template;
    }

    /**
     * @return mixed
     */
    public function getPreparedTemplate()
    {
        return $this->prepared_template;
    }

    public function offsetExists($offset)
    {
        return method_exists($this, $offset);
    }

    public function offsetGet($offset)
    {
        return call_user_func(array($this, $offset));
    }

    public function offsetSet($offset, $value)
    {
        // nothing to do
    }

    public function offsetUnset($offset)
    {
        // nothing to do
    }

    /**
     * @param $locationData
     * @return array
     * Gets all data saved for the location and should return array needed
     */
    public function prepareFromData($locationData)
    {
        $locationData['locationId']=$this->getLocationId();

        return $locationData;
    }

    /**
     * @param $locationData
     * @return mixed
     * Prepared specifically the data needed for admin template rendering - phrases etc.
     */
    public function preparePhrasesFromData($locationData)
    {
        $locationData['title'] = $this->getTitle();
        $locationData['group'] = $this->getGroup();
        $locationData['description'] = $this->getDescription();
        $locationData['explain_image'] = $this->getExplainImage();

        return $locationData;
    }

    public function getPreparedHtml()
    {
        return rand();
    }

    /**
     * @return bool
     * Return false to use safe mode for all banners in this location
     */
    protected function _forceSafeMode()
    {
        return false;
    }
}